# 画面設計書 18-Streaming Overview（DStreamsストリーミング概要）

## 概要

本ドキュメントは、Apache Spark Application UIのStreamingタブにあるDStreamsストリーミング概要画面の設計内容を記述する。本画面はDStreamsストリーミングジョブのスケジューリング遅延・処理時間・総遅延をタイムライン/ヒストグラムで表示し、バッチの一覧をRunning/Waiting/Completedに分類して表示する。

### 本画面の処理概要

**業務上の目的・背景**：Spark DStreams（レガシーストリーミングAPI）を使用したリアルタイムデータ処理において、バッチ処理のパフォーマンスを継続的に監視する画面である。運用者はInput Rate（入力レート）、Scheduling Delay（スケジューリング遅延）、Processing Time（処理時間）、Total Delay（総遅延）の各メトリクスをタイムライン・ヒストグラムで確認できる。また、レシーバーの稼働状況やバッチの処理状態（Running/Waiting/Completed）を一覧で把握でき、ストリーミングジョブの健全性を包括的に監視できる。

**画面へのアクセス方法**：SparkUIのタブバーにある「Streaming」タブをクリックすることでアクセスする。DStreamsを使用しているアプリケーションでのみタブが表示される。

**主要な操作・処理内容**：
1. 基本情報（バッチインターバル、稼働時間、開始日時、完了バッチ数、レコード数）を確認する
2. Input Rateのタイムライン・ヒストグラムを確認する（レシーバー別詳細展開可能）
3. Scheduling Delay/Processing Time/Total Delayのタイムライン・ヒストグラムを確認する
4. Input Rateセクション展開でレシーバー別の受信状況を確認する
5. Running/Waiting/Completedバッチ一覧を確認する
6. バッチ時刻リンクからバッチ詳細画面（No.19）へ遷移する

**画面遷移**：SparkUIのタブバーから直接アクセスする。本画面からバッチ詳細画面（No.19）へ遷移可能。タイムライングラフのバッチクリックでもバッチ詳細へ遷移する。

**権限による表示制御**：DStreamsモジュール未使用の場合、Streamingタブ自体が表示されない。ACL設定が有効な場合、閲覧権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | DStreamsストリーミングのスケジューリング遅延・処理時間・総遅延をタイムライン/ヒストグラムで表示する主処理 |
| 40 | DStreamストリーム処理 | 主機能 | StreamingJobProgressListenerから各バッチの処理時間・スケジューリング遅延・入力レートを取得して表示 |
| 41 | レシーバー管理 | 補助機能 | レシーバーの稼働状況・受信レート情報をテーブル表示 |

## 画面種別

一覧（ダッシュボード）

## URL/ルーティング

- パス: `/streaming/`
- パラメータ（ページング用）:
  - `{tag}.page` - ページ番号（tag: runningBatches/waitingBatches/completedBatches）
  - `{tag}.sort` - ソートカラム
  - `{tag}.desc` - 降順フラグ
  - `{tag}.pageSize` - ページサイズ
- 例: `/streaming/`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| {tag}.page | 入力（URLパラメータ） | Int | 任意 | ページ番号。デフォルト: 1 |

## 表示項目

### 基本情報セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Batch Duration | Long | バッチインターバル（人間可読形式） |
| Running Time | Long | 稼働時間 |
| Start Time | Date | ストリーミング開始日時 |
| Completed Batches | Long | 完了バッチ数 |
| Total Records | Long | 総処理レコード数 |

### 統計テーブル（タイムライン + ヒストグラム）

| メトリクス名 | 単位 | 説明 |
|-------------|------|------|
| Input Rate | records/sec | 入力レート（全ストリーム集約）。レシーバー数とActive数も表示。平均値表示 |
| Scheduling Delay | 動的単位 | バッチスケジューリング遅延。平均値表示 |
| Processing Time | 動的単位 | バッチ処理時間。平均値表示。バッチインターバルの基準線表示あり |
| Total Delay | 動的単位 | 総遅延（スケジューリング遅延+処理時間）。平均値表示 |

### Input DStreams テーブル（展開表示）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Receiver Name | String | レシーバー名 / ストリーム名 |
| Avg Records/sec | String | 平均受信レート |
| Status | String | ACTIVE / INACTIVE |
| Executor ID / Host | String | レシーバー実行場所 |
| Last Error Time | Date | 最終エラー日時 |
| Last Error Message | String | 最終エラーメッセージ |

### バッチ一覧テーブル（Running/Waiting/Completed）

ページングテーブルで表示。各バッチの時刻（リンク）、入力サイズ、処理時間等を表示。

## イベント仕様

### 1-Input Rate展開/折りたたみ

Input Rateセクションのヘッダをクリックすると、レシーバー別の詳細テーブル（Input DStreams）の表示/非表示を切り替える。expand-input-rateクラスで制御。

### 2-タイムライングラフのバッチクリック

タイムライングラフ上のバッチポイントをクリックすると、該当バッチの詳細画面（/streaming/batch/?id={batchTime}）へ遷移する。onClickTimeline関数で制御。

### 3-バッチ一覧セクション折りたたみ

Running/Waiting/Completedの各セクションヘッダをクリックすると、該当テーブルが折りたたみ/展開される。

### 4-バッチ時刻リンククリック

バッチ一覧テーブルのバッチ時刻リンクをクリックすると、バッチ詳細画面（No.19）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | - | SELECT | StreamingJobProgressListenerから保持バッチ・レシーバー情報を取得 |

本画面はデータベースへの更新操作を行わない。listenerオブジェクトのsynchronizedブロック内でデータを取得する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | "Error while rendering streaming table: {exception}" | テーブルレンダリング中に例外が発生した場合 |

## 例外処理

- テーブルレンダリングエラー: IllegalArgumentExceptionまたはIndexOutOfBoundsExceptionをキャッチし、エラーメッセージ表示

## 備考

- DStreams APIはレガシーAPIであり、Structured Streaming（No.16, 17）の使用が推奨される
- D3.js（d3.min.js）を使用してグラフを描画
- streaming-page.css、streaming-page.jsの静的リソースを使用
- Scheduling Delay/Processing Time/Total Delayの時間単位は値の大きさに応じて動的に正規化される（ms/sec/min等）
- Processing Timeのタイムラインにはバッチインターバルの基準線が表示され、処理時間がインターバルを超えているかを視覚的に判定可能
- listenerオブジェクトのsynchronizedブロックを使用し、データ取得時の一貫性を確保
- ページタイトルは「Streaming Statistics」

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BatchUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/UIUtils.scala` | BatchUIDataクラスのフィールド（batchTime, numRecords, schedulingDelay, processingDelay, totalDelay, outputOperations等） |
| 1-2 | MillisecondsStatUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 行37-56: 時間系メトリクスのヘルパークラス。timelineData/histogramData/avg/max |
| 1-3 | RecordRateUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 行64-71: レコードレートメトリクスのヘルパークラス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamingTab.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` | 行28-48: StreamingTabクラス。StreamingPageとBatchPageを登録。listener = ssc.progressListener |
| 2-2 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 行74-75: WebUIPage("")でデフォルトページ |

**主要処理フロー**:
1. **行84**: renderメソッドでresources/basicInfo/statTable/batchListTablesを生成
2. **行88-93**: listener.synchronizedブロック内でstatTableとbatchListTablesを生成
3. **行124-141**: generateBasicInfoで基本情報HTML生成
4. **行172-347**: generateStatTableでメトリクスグラフ群を生成
5. **行471-537**: generateBatchListTablesでRunning/Waiting/Completedバッチ一覧を生成

#### Step 3: グラフ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 行172-347: generateStatTableメソッド。GraphUIDataでInput Rate/Scheduling Delay/Processing Time/Total Delayグラフ生成 |
| 3-2 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 行349-444: generateInputDStreamsTableとgenerateInputDStreamRowでレシーバー別テーブル生成 |

### プログラム呼び出し階層図

```
StreamingTab [行28]
    |
    +-- listener = ssc.progressListener [行34]
    |
    +-- StreamingPage (WebUIPage("")) [行36]
            |
            +-- render(request) [行84]
                    |
                    +-- generateLoadResources(request) [行85]
                    +-- generateOnClickTimelineFunction(request) [行86]
                    +-- generateBasicInfo() [行87]
                    |
                    +-- listener.synchronized {
                    |       +-- generateStatTable(request) [行91]
                    |       |       |
                    |       |       +-- listener.retainedBatches
                    |       |       +-- RecordRateUIData (Input Rate)
                    |       |       +-- MillisecondsStatUIData (Scheduling Delay)
                    |       |       +-- MillisecondsStatUIData (Processing Time)
                    |       |       +-- MillisecondsStatUIData (Total Delay)
                    |       |       +-- GraphUIData x 4
                    |       |       +-- generateInputDStreamsTable()
                    |       |
                    |       +-- generateBatchListTables(request) [行92]
                    |               +-- Running/Waiting/Completed分類
                    |               +-- StreamingPagedTable x 3
                    |   }
```

### データフロー図

```
[入力]                          [処理]                              [出力]

(パラメータなし) ──────────> StreamingPage.render()
                                   |
                                   +---> StreamingJobProgressListener
                                   |     (synchronized)
                                   |     .retainedBatches
                                   |     .receivedRecordRateWithBatchTime
                                   |     .receiverInfo
                                   |           |
                                   +---> generateBasicInfo() ──────> 基本情報HTML
                                   |
                                   +---> generateStatTable() ──────> 統計グラフHTML
                                   |     (GraphUIData x 4+)
                                   |     +--- generateInputDStreamsTable()
                                   |          ──> レシーバー別テーブル
                                   |
                                   +---> generateBatchListTables() ─> バッチ一覧HTML
                                   |     (Running/Waiting/Completed)
                                   |
                                   +---> headerSparkPage() ────────> 完成ページHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | ソース | メイン画面ページクラス |
| StreamingTab.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` | ソース | タブ定義 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | ストリーミングジョブ進捗リスナー |
| UIUtils.scala (streaming) | `streaming/src/main/scala/org/apache/spark/streaming/ui/UIUtils.scala` | ソース | DStreams UIユーティリティ |
| GraphUIData.scala | `core/src/main/scala/org/apache/spark/ui/GraphUIData.scala` | ソース | タイムライン・ヒストグラム汎用クラス |
| JsCollector.scala | `core/src/main/scala/org/apache/spark/ui/JsCollector.scala` | ソース | JavaScript集約ユーティリティ |
| d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/d3.min.js` | JavaScript | D3.jsライブラリ |
| streaming-page.css | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.css` | CSS | ストリーミングページスタイル |
| streaming-page.js | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.js` | JavaScript | ストリーミングページロジック |
